<?php

require_once "configuracion/inicio.php";

use src\infrastructure\email\Email;
use src\application\TokenValidEmail;
use src\application\user\UserGetRequest;
use src\infrastructure\sql\SqlUserRepository;
use src\application\provider\ProviderActive;

$success = FALSE;

if(isset($_GET['token'])){

    $UserRepository = new SqlUserRepository();
    $emailSender = new Email();

    try{

        $tokenValid = new TokenValidEmail();
        $dataUser = $tokenValid->getData($_GET['token']);
        $request = new UserGetRequest($dataUser->id,'id');
        $validUser = new ProviderActive($UserRepository,$emailSender);;
        $validUser = $validUser->execute($request);
        $success = $validUser['success'];
        $msj = $validUser['message'];

    }catch(Exception $e){ 
        $msj = 'La url solicitada ya no es v&aacute;lida. Por favor vuelva a realizar el proceso de validaci&oacute;n';
        $success = FALSE;
    }

}
?>
<!DOCTYPE html>
<html>
    <head>
        <?php require_once "template/manager/head.php"; ?>
    </head>

    <body>
        <?php require_once "template/preloader.php"; ?>
        <section>
            <div class="container-alt">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="wrapper-page">
                            <div class="m-t-40 account-pages">
                                <div class="text-center account-logo-box">
                                    <h2 class="text-uppercase">
                                        <span><img src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/images/mym.png" alt="M Y M Pl&aacute;sticos" class="center-page" style="height:90px;"></span>
                                    </h2>
                                </div>
                                <div class="account-content">
									<div class="page" id="login-page">
                                        <?php if($success){
                                        ?>
                                        <h4 class="text-center text-success"><?php echo $msj; ?></h4>
                                        <?php
                                        }else{
                                        ?>
										<h4 class="text-center text-danger"><?php echo $msj; ?></h4>
                                        <?php  } ?>
										<p class="text-center">
                                            <a href="<?php echo $GLOBALS['domain_root']; ?>" class="btn w-md btn-bordered btn-success waves-effect waves-light">Ir al Inicio</a>
                                        </p>
									</div>
									<div class="clearfix"></div>
                                </div>
                            </div>

                        </div>
                        <!-- end wrapper -->

                    </div>
                </div>
            </div>
          </section>
          <!-- END HOME -->
		<?php require_once "template/manager/js.php"; ?>

    </body>
</html>
