<?php
namespace src\utils;

class Paginator {
	var $records;
	var $pages;
	var $recordsperpage;
	var $actual_page=1;
	var $url_page="";
	var $start_record;

	public function __construct($records, $recordsperpage, $url_page = "",$pg) {
		$this->url_page = $url_page;
		$this->records=$records;
		$this->recordsperpage=$recordsperpage;
		if ($pg) {
			$this->actual_page=$pg;
		}
		if ($pg) {
			$this->start_record=($pg * $recordsperpage) - $recordsperpage;
		}else {
			$this->start_record=0;
		}
	}

	function get_total_pages() {
		$total=(($this->records%$this->recordsperpage==0)? $this->records/$this->recordsperpage : floor($this->records/$this->recordsperpage) +1);

			$this->pages=$total;
			return $total;
	}

	function print_paginator($type="") {
		$sep=((substr_count($this->url_page,"/")==0)? "/" : "/");
		$cad=(($this->actual_page!=1)? "<li><a href='".$this->url_page.$sep."pg/1'>&laquo;</a></li> ": "");
		if ($this->url_page=="") {
			$cad.=(($this->actual_page!=1)? "<li><a href='/pg/".(($this->actual_page)-1)."'>&lsaquo;</a></li>": "");
			$linkc=$sep;
		}else {
			$cad.=(($this->actual_page!=1)? "<li><a href='".$this->url_page.$sep."pg/".(($this->actual_page)-1)."'>&lsaquo;</a></li> ": "");
			$linkc= $this->url_page.$sep;
		}
		if ($this->pages>5) {
			if ($this->actual_page<=2) {
				$inicio=1;
				$fin=5;
			} else {
				$inicio=$this->actual_page-2;
				if (($this->actual_page+2)<$this->pages) {
					$fin=$this->actual_page+2;
				}else {
					$fin=$this->pages;
				}
			}
		} else {
			$inicio=1;
			$fin=$this->pages;
		}
		for($i=$inicio;$i<=$fin; $i++) {
			$link= $linkc . "pg/" . $i ;
			if ($i==$this->actual_page) {
				$cad.="<li class='active'><a href='#'>". $i . "</a></li> ";
			} else {
				$cad.= "<li><a href='$link'>" . $i . "</a></li> ";
			}
		}
		if ($this->url_page=="") {
			$cad.=(($this->actual_page!=$this->pages)? "<li><a href='".$sep."pg/".(($this->actual_page)+1)."'>&rsaquo;</a></li> ": "");
		}else {
			$cad.=(($this->actual_page!=$this->pages)? "<li><a href='".$this->url_page.$sep."pg/".(($this->actual_page)+1)."'>&rsaquo;</a></li> ": "");
		}
		$cad.=(($this->actual_page!=$this->pages)? "<li><a href='".$this->url_page.$sep."pg/".($this->pages)."'>&raquo;</a></li> ": "");
		if ($this->pages>1) {
			echo $cad;
		}
	}

	function print_page_counter($labelpage="Pagina", $labelof="de") {
		if ($this->pages>1) {
			$objLan = unserialize($_SESSION["obj_language"]);
			echo $labelpage. " " . $this->actual_page . " ". $labelof. " " . $this->pages;
		}
	}
}

?>
