<?php
namespace src\infrastructure\sql;

class SqlSearchSpecification implements SqlSpecification{

    private $fields;
    private $limits;
    private $parametersSql;

    public function __construct(array $fields, array $limits) {

        $this->fields = $fields;
		$this->limits = $limits;
		$this->parametersSql = [];

    }

    public function toSqlClauses(string $orderby = 'id', bool $status = true, bool $groupby  = true) : string{

        $fieldStatus = $index = 0;
        $totalField = count($this->fields);
        $sql = '';

		if($totalField > 0){

			$sql .= ' WHERE ';

			foreach ($this->fields as $field => $value) {

				if($field == "status"){
					$fieldStatus = 1;
				}

				if(is_string($value)){

					$sql .= " ".$field." LIKE ? ";
					$value = "%".$value."%";
					$this->parametersSql[] = $value;

				}else{

					$sql .= " ".$field." = ? ";
					$this->parametersSql[] = $value;

				}

				if($index != $totalField-1){
					$sql .= "AND";
				}
				$index++;

			}
		}
		if($status){

			if($fieldStatus == 0){
				
				if($totalField == 0){
	
					$sql .= ' WHERE ';
	
				}else{
	
					$sql .= ' AND ';
	
				}

				$sql .= " status != ? ";
				$this->parametersSql[] = 2;
			}
		}
		if($groupby){
			$sql .= "GROUP BY ".$orderby." ORDER BY ".$orderby." DESC";
		}

		if( isset($this->limits[0]) && isset($this->limits[1]) ){
			$sql .= " LIMIT ?, ? ";
			$this->parametersSql[] = $this->limits[0];
			$this->parametersSql[] = $this->limits[1];
		}

        return $sql;

    }

    public function getParameters() : array {

        return $this->parametersSql;

    }

}
