<?php
declare(strict_types=1);
namespace src\infrastructure\sql;

use src\domain\event\LogEventStore;
use src\domain\event\LogEventStored;
use src\domain\event\LogEvent;

class SqlLogEventStore implements LogEventStore{

    private $conexion;
	private $fields;
	private $table;


    public function __construct() {

        $this->conexion = new Conexion();
		$this->fields = 'user,ip,browser,date_add,action,section';
		$this->table = 'log';

    }

    public function search(array $parameters = [],array $limits = []): array {

        $events = array();
        $specification = new SqlLogEventSpecification($parameters,$limits);

		$sql = "SELECT ".$this->fields." FROM ".$this->table." ".$specification->toSqlClauses();

		if($lista = $this->conexion->listquery($sql,$specification->getParameters())) {

			foreach($lista as $list){
				$events[] = $this->createLogEvent($list);
			}

		}
        return $events;

    }

    public function totalSearch(array $parameters = []): int {

        $specification = new SqlLogEventSpecification($parameters,array());
        $sql = "SELECT COUNT(id) as c FROM ".$this->table." ".$specification->toSqlClauses();
		$total = $this->conexion->query($sql,$specification->getParameters());
		return intval($total['c']);

    }

    public function add(LogEvent $event): bool {

		try{

			$sql = "INSERT INTO ".$this->table." (".$this->fields.") VALUES (?,?,?,NOW(),?,?)";
	
			$optiones = array(
				$event->getUser(),
				$event->getIp(),
				$event->getBrowser(),
				$event->getAction(),
				$event->getSection()
			);
	
			return $this->conexion->execute($sql,$optiones);

		}catch(Exception $e){

			throw new Exception($e->getMessage());

		}


    }

    private function createLogEvent(array $row){

        $logEvent = new LogEventStored(
			intval($row['user']),
			$row['section'],
			utf8_decode($row['action']),
			$row['browser'],
			$row['ip'],
			$row['date_add']
		);

        return $logEvent;

    }
}
