<?php
namespace src\infrastructure\sql;

class SqlLogEventSpecification implements SqlSpecification{

    private $fields;
    private $limits;
    private $parametersSql;

    public function __construct(array $fields, array $limits) {

        $this->fields = $fields;
        $this->limits = $limits;

    }

    public function toSqlClauses(string $orderby = 'id', bool $status = false) : string{

        $index = 0;
        $totalField = count($this->fields);
        $sql = ' WHERE ';


		if($totalField > 0){

			foreach ($this->fields as $field => $value) {

				if(is_string($value)){ 

                    if( $field == 'date'){

                        $valueDate = explode(',',$value);
                        $sql .= " (date_add BETWEEN ? AND ? )";
						$this->parametersSql[] = $valueDate[0];
					    $this->parametersSql[] = $valueDate[1];

                    }else{

                        $sql .= " ".$field." LIKE ? ";
                        $value = "%".$value."%";
                        $this->parametersSql[] = $value;

                    }

				}else{

					$sql .= " ".$field." = ? ";
					$this->parametersSql[] = $value;

				}

				if($index != $totalField-1){
					$sql .= "AND";
				}
				$index++;

			}
        }
        
		$sql .= " ORDER BY ".$orderby." DESC";

		if( isset($this->limits[0]) && isset($this->limits[1]) ){
			$sql .= " LIMIT ?, ? ";
			$this->parametersSql[] = $this->limits[0];
			$this->parametersSql[] = $this->limits[1];
		}

        return $sql;

    }

    public function getParameters() : array {

        return $this->parametersSql;

    }

}
