<?php
declare(strict_types=1);
namespace src\infrastructure\sql;

use Exception;
use src\domain\document\Category;
use src\domain\document\CategoryCustom;
use src\domain\document\CategoryRepository;

class SqlCategoryRepository implements CategoryRepository{

    private $conexion;
    private $fields;
	private $table;

    public function __construct() {

        $this->conexion = new Conexion();
		$this->fields = 'name,ico,type,status,user_add,date_add,user_update,date_update';
		$this->table = 'category';
    }

    public function getCategory(string $field, $value): Category{

        $sql = "SELECT id,".$this->fields." FROM ".$this->table." WHERE ".$field." = ?";
        
		$optiones = array($value);
		if($row = $this->conexion->query($sql,$optiones)) {

			return $this->createCategory($row);

		} else {

            throw new Exception('La categor&iacute;a no se encuentra registrado');

        }

	}

    public function search(array $parameters = [],array $limits = []): array {

        $users = array();
        $specification = new SqlSearchSpecification($parameters,$limits);

		$sql = "SELECT id,".$this->fields." FROM ".$this->table." ".$specification->toSqlClauses('id',false);

		if($lista = $this->conexion->listquery($sql,$specification->getParameters())) {

			foreach($lista as $list){
				$users[] = $this->createCategory($list);
			}

		}

        return $users;

	}

    public function totalSearch(array $parameters = []): int {

        $specification = new SqlSearchSpecification($parameters,array());
        $sql = "SELECT COUNT(id) as c FROM ".$this->table." ".$specification->toSqlClauses('id',false);
		$total = $this->conexion->query($sql,$specification->getParameters());
		return intval($total['c']);

    }

    public function add(Category $category): Category {

		try{

			$sql = "INSERT INTO ".$this->table." (".$this->fields.") VALUES (?,?,?,?,?,NOW(),?,NOW())";
	
			$optiones = array(
				$category->getName(),
				$category->getIco(),
				$category->getType(),
				$category->getStatus(),
				$category->getUserAdd(),
				$category->getUserUpdate()
			);
	
			$saved = $this->conexion->execute($sql,$optiones);
	
			if($saved){
	
				$category->setId( $this->conexion->lastId() );
	
			}
	
			return $category;

		}catch(Exception $e){

			throw new Exception($e->getMessage());

		}


    }

    public function update(Category $category): bool {

		try{

			$sql = "UPDATE ".$this->table." SET name = ?,ico = ? ,date_update=NOW(), user_update=? WHERE id=?";
	
			$optiones = array(
				$category->getName(),
				$category->getIco(),
				$category->getUserUpdate(),
				$category->getId()
			);
			return $this->conexion->execute($sql,$optiones);

		}catch(Exception $e){

			throw new Exception($e->getMessage());

		}


    }

    public function delete(Category $category): bool {

        $sql = "DELETE FROM ".$this->table." WHERE id=?";
		$optiones = array($category->getId());
		return $this->conexion->execute($sql,$optiones);

    }

    public function changeStatus(Category $category): bool {

        $sql = "UPDATE ".$this->table." SET status=? WHERE id=?";
		$optiones = array($category->getStatus(),$category->getId());
		return $this->conexion->execute($sql,$optiones);

	}

    private function createCategory(array $row) : Category{

		return CategoryCustom::fromRawData($row);

    }
}
