<?php
namespace src\infrastructure\sql;
use PDO;

class Conexion{

	/*********************************************ATRIBUTOS**************************************/
	private $conexion;
	private $servidor = "localhost";
	private $usuario = "mymplastic_docuuser";
	private $bd = "mymplastic_documentsmanager";
	private $clave = "vRP#52snkX+u";

	/*****************************************CONSTRUCTORES****************************************/

	public function __construct(){

		try{
			$this->conexion = new PDO('mysql:host='.$this->servidor.';dbname='.$this->bd, $this->usuario, $this->clave, array(PDO::ATTR_PERSISTENT => true));
			$this->conexion->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$this->conexion->setAttribute(PDO::ATTR_EMULATE_PREPARES, FALSE);
			$this->conexion->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, FALSE);
		}catch(PDOException $e){
			echo "ERROR: " . $e->getMessage();
		}

	}

	public function beginTransaction(){
		return $this->conexion->beginTransaction();
	}

	public function commit(){
		return $this->conexion->commit();
	}

	public function rollback(){
		return $this->conexion->rollback();
	}

	public function query($sql,$options){
		try {
			$consulta = $this->conexion->prepare($sql);
			$result = $consulta->execute($options);
			return $consulta->fetch(PDO::FETCH_ASSOC);
		} catch (PDOException $e) {
			echo "ERROR: " . $e->getMessage();
		}
	}

	public function listquery($sql,$options){
		try {
			$consulta = $this->conexion->prepare($sql);
			$result = $consulta->execute($options);
			return $consulta->fetchAll(PDO::FETCH_ASSOC);
		} catch (PDOException $e) {
			echo "ERROR: " . $e->getMessage();
		}
	}

	public function execute($sql,$options){
		try {
			$consulta = $this->conexion->prepare($sql);
			$result = $consulta->execute($options);
			return $result;
		} catch (PDOException $e) {
			echo "ERROR: " . $e->getMessage();
		}
	}

	public function lastId(){
		return $this->conexion->lastInsertId();
	}

}
?>
