<?php
namespace src\infrastructure\email;

use src\EmailInterface;

class Email implements EmailInterface {

    private $from = 'info@mymplasticos.com';

    public function __construct(){}

	function sendNewPassword(string $email, string $password):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/recuperar_admin.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

        $html_mail = str_replace("#LOGIN#",$email,$html_mail);
		$html_mail = str_replace("#CONTRA#",$password,$html_mail);

		$contenido = $html_mail;
		$asunto = "Recuperar Clave";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}
	function sendNewPasswordProvider(string $name, string $email, string $password):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/recuperar.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

        $html_mail = str_replace("#LOGIN#",$email,$html_mail);
		$html_mail = str_replace("#CONTRA#",$password,$html_mail);
		$html_mail = str_replace("#NAME#",$name,$html_mail);
		
		$contenido = $html_mail;
		$asunto = "Recuperar Clave";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}

	function sendValid(string $name, string $email, string $url):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/validar.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

        $html_mail = str_replace("#URL#",$url,$html_mail);
		$html_mail = str_replace("#NAME#",$name,$html_mail);

		$contenido = $html_mail;
		$asunto = $name.", por favor valide su cuenta de email";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}
	function activeAccount(string $name, string $email, string $password):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/activar_cuenta.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

		$html_mail = str_replace("#LOGIN#",$email,$html_mail);
		$html_mail = str_replace("#CONTRA#",$password,$html_mail);
		$html_mail = str_replace("#NAME#",$name,$html_mail);

		$contenido = $html_mail;
		$asunto = "Ya casi terminamos ".$name.", solo un paso mas";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}
	function confirmValid(string $name, string $email):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/confirmarvalidacion.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

		$html_mail = str_replace("#NAME#",$name,$html_mail);

		$contenido = $html_mail;
		$asunto = "Validacion de Email";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}

	function notification(string $name, string $email, string $text, string $title):bool{

		$html_mail = '';
		$arrhtml_mail = file($GLOBALS['app_root'].'/src/utils/correo/notification.php');
		
		for($i = 0; $i < count($arrhtml_mail); $i++) {
			$html_mail .= $arrhtml_mail[$i];
		}

		$html_mail = str_replace("#NAME#",$name,$html_mail);
		$html_mail = str_replace("#TXT#",$text,$html_mail);
		$html_mail = str_replace("#TITLE#",$title,$html_mail);

		$contenido = $html_mail;
		$asunto = "Notificacion";

		//para el envío en formato HTML
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

		//dirección del remitente
		$headers .= "From:".$this->from;

		return mail($email,$asunto,$contenido,$headers) ;

	}

}
?>
