<?php
declare(strict_types=1);
namespace src\domain\validation;

class ValidationHandler{

    private $errors;
    private $warnings;
    private $totalError;
    private $totalWarnings;

    public function __construct(){

        $this->errors = array();
        $this->warnings = array();
        $this->totalError = 0;
        $this->totalWarnings = 0;
    }

    /**
     * Agrega el error en la lista correspondiente
     *
     * @param string $error
     * @return void
    */
    public function addError(string $error) {
        
        $this->errors[] = $error;
        $this->totalError++;

    }

    /**
     * Indica si hay un mensaje de error
     *
     * @return boolean
     */
    public function hasError() : bool {

        return ($this->totalError > 0);

    }

    /**
     * Retorna en un solo string los errores encontrados
     *
     * @return string
     */
    public function printErrors() : string {

        $errors = '';

        foreach($this->errors as $error){

            $errors .= $error.'/n';

        }

        return $errors;

    }

    /**
     * Agrega el warning en la lista correspondiente
     *
     * @param string $warning
     * @return void
    */
    public function addWarning(string $warning) {
        
        $this->warnings[] = $warning;
        $this->totalWarnings++;

    }

    /**
     * Indica si hay un mensaje de advertencia
     *
     * @return boolean
     */
    public function hasWarning() : bool {

        return ($this->totalWarnings > 0);

    }

    /**
     * Retorna en un solo string las advertencias encontradas
     *
     * @return string
     */
    public function printWarnings() : string {

        $warnings = '';

        foreach($this->warnings as $warning){

            $warnings .= $warning.'/n';

        }

        return $warnings;

    }

}
?>