<?php
declare(strict_types=1);
namespace src\domain\user\webmaster;

use src\domain\event\LogEventData;

class WebmasterChangedPassword extends LogEventData {

    private $userSaved;

	public function __construct(int $user, string $userSaved){

        $this->userSaved = $userSaved;
        parent::__construct($user);
	}

    public function getSection() : string {
        return 'webmaster';
    }
    
    public function getAction() : string {
        return 'Recuper&oacute; su clave ';
    }

}
?>
