<?php
declare(strict_types=1);
namespace src\domain\user\webmaster;

use Exception;
use src\domain\user\User;
use src\domain\user\UserDTO;
use src\domain\user\UserValidation;
use src\domain\event\LogEventPublisher;
use src\domain\validation\ValidationHandler;

class Webmaster extends User{

	public function __construct(
        ?int $id,
        string $name,
        string $email,
        string $password,
        int $status,
        int $type,
        ?int $userAdd,
        ?int $userUpdate,
        ?string $dateAdd, 
        ?string $dateUpdate
    ){

        $errors = $this->canSave($name, $email, $password);
        if(!$errors->hasError()){

            parent::__construct($id,$name,$email,$type,$password,$status,$userAdd,$userUpdate,$dateAdd,$dateUpdate);
            LogEventPublisher::instance()->publish(
                new WebmasterCreated($this->userAdd,$this->name)
            );
               


        }else{

            throw new Exception( $errors->printErrors() );

        }

        
    }
    
    public static function canSave(string $name,string $email, string $password = '') : ValidationHandler{
        
        $userValidator = new UserValidation();
        return $userValidator->canSaveWebmaster($name,$email,$password);
        
    }

    public function update( UserDTO $userData ){

        $errors = $this->canSave($userData->name, $userData->email);
        if(!$errors->hasError()){

            $this->name = $userData->name;
            $this->email = $userData->email;
            $this->userUpdate = $userData->userUpdate;
            $this->dateUpdate = date('Y-m-d H:i:s');
            LogEventPublisher::instance()->publish(
                new WebmasterUpdated($this->userUpdate,$this->name)
            );
               


        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function changeStatusWebmaster( int $newStatus , int $idUserUpdate ){

        $this->changeStatus($newStatus,$idUserUpdate);

        if( $newStatus == 2){

            LogEventPublisher::instance()->publish(
                new WebmasterDeleted($this->userUpdate,$this->name)
            );

        }else{

            LogEventPublisher::instance()->publish(
                new WebmasterUpdated($this->userUpdate,$this->name)
            );

        }


    }

    public function changePasswordWebmaster( string $password, int $idUser ){

        $errors = $this->canChangePassword($password);
        if(!$errors->hasError()){

            $this->changePassword($password,$idUser);
            LogEventPublisher::instance()->publish(
                new WebmasterChangedPassword($this->id,$this->name)
            );
               


        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function RecoveryPasswordWebmaster( string $password){

        $errors = $this->canChangePassword($password);
        if(!$errors->hasError()){

            $this->RecoveryPassword($password);
            LogEventPublisher::instance()->publish(
                new WebmasterRecoveredPassword($this->getId())
            ); 

        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

}
?>
