<?php
declare(strict_types=1);
namespace src\domain\user\provider;

use src\domain\event\LogEventData;

class ProviderDeleted extends LogEventData {

    private $userSaved;

	public function __construct(int $user, string $userSaved){

        $this->userSaved = $userSaved;
        parent::__construct($user);
	}

    public function getSection() : string {
        return 'student';
    }
    
    public function getAction() : string {
        return 'Elimin&oacute; al provider '.$this->userSaved;
    }

}
?>
