<?php
declare(strict_types=1);
namespace src\domain\user\provider;

use Exception;
use src\domain\user\User;
use src\domain\user\UserValidation;
use src\domain\event\LogEventPublisher;
use src\domain\validation\ValidationHandler;

class Provider extends User{

    protected $ci;
    protected $valid;

	public function __construct(
        ?int $id,
        string $name,
        string $email,
        string $ci,
        int $type,
        int $status,
        ?int $userAdd,
        ?int $userUpdate,
        ?string $dateAdd, 
        ?string $dateUpdate
    ){

        $errors = $this->canSave($name, $ci, $email);
        if(!$errors->hasError()){

            parent::__construct($id,$name,$email,$type,'',$status,$userAdd,$userUpdate,$dateAdd,$dateUpdate);
            $this->students = array();
            $this->ci = $ci;
            $this->valid = 0;
            LogEventPublisher::instance()->publish(
                new ProviderCreated($this->userAdd,$this->name)
            );

        }else{

            throw new Exception( $errors->printErrors() );

        }

        
    }
    
    public static function canSave(string $name, string $ci,string $email) : ValidationHandler{
        
        $userValidator = new UserValidation();
        return $userValidator->canSaveProvider($name,$email,$ci);
        
    }

    public function update( ProviderDTO $userData ){

        $errors = $this->canSave($userData->name, $userData->ci, $userData->email);
        if(!$errors->hasError()){

            $this->name = $userData->name;
            $this->ci = $userData->ci;
            $this->email = $userData->email;
            $this->userUpdate = $userData->userUpdate;
            $this->dateUpdate = date('Y-m-d H:i:s');
            LogEventPublisher::instance()->publish(
                new ProviderUpdated($this->userUpdate,$this->name)
            );
               


        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function delete( int $idUserUpdate ){

        LogEventPublisher::instance()->publish(
            new ProviderDeleted($this->userUpdate,$this->name)
        );

    }

    public function changeStatusProvider( int $newStatus , int $idUserUpdate ){

        $this->changeStatus($newStatus,$idUserUpdate);

        LogEventPublisher::instance()->publish(
            new ProviderUpdated($this->userUpdate,$this->name)
        );

    }
    
    public function active( string $password ){

        $errors = $this->canChangePassword($password);
        if(!$errors->hasError()){

            $this->valid = 1;
            $this->changePassword($password,$this->id);
            LogEventPublisher::instance()->publish(
                new ProviderActived($this->id)
            );
               
        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function validateEmail(){

        $this->valid = 1;

        LogEventPublisher::instance()->publish(
            new ProviderEmailValidaded($this->id)
        );

    }

    public function changePasswordProvider( string $password, int $idUser ){

        $errors = $this->canChangePassword($password);
        if(!$errors->hasError()){

            $this->changePassword($password,$idUser);
            LogEventPublisher::instance()->publish(
                new ProviderChangedPassword($this->id,$this->name)
            );
               
        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function RecoveryPasswordProvider( string $password){

        $errors = $this->canChangePassword($password);
        if(!$errors->hasError()){

            $this->RecoveryPassword($password);
            LogEventPublisher::instance()->publish(
                new ProviderRecoveredPassword($this->getId())
            ); 

        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function getCi(){
        return $this->ci;
    }

    public function getValid(){
        return $this->valid;
    }
}
?>
