<?php
declare(strict_types=1);
namespace src\domain\user;

use src\domain\validation\Validator;
use src\domain\validation\ValidationHandler;

class UserValidation extends Validator{

    const MAXPASS = 8;

	public function __construct(){

        $validationHandler = new ValidationHandler();
        parent::__construct($validationHandler);

    }
    
    private function validateGeneralData(string $name, string $email){

        if($name == ''){
            $this->validationHandler->addError('El nombre es obligatorio');
        }
        if($email == ''){
            $this->validationHandler->addError('El email es obligatorio');
        }else if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
            $this->validationHandler->addError('Formato de email incorrecto');
        }

    }
    
    public function validStudent(string $name){

        if($name == ''){
            $this->validationHandler->addError('El nombre del estudiante es obligatorio');
        }

    }

    
    private function validatePassword(string $password){
        
        if( strlen($password)  <= self::MAXPASS ){
            
            $this->validationHandler->addError('La clave debe contener m&iacute;nimo '.self::MAXPASS.' car&aacute;cteres ');
            
        }
        
    }
    
    public function canSaveWebmaster(string $name, string $email, string $password = '') : ValidationHandler{

        $this->validateGeneralData($name,$email);
        if($password != ''){
            $this->validatePassword($password);
        }
        return $this->validationHandler;

    
    }

    public function canSaveProvider(string $name, string $email, string $ci) : ValidationHandler{

        $this->validateGeneralData($name,$email);
        if($ci == ''){
            $this->validationHandler->addError('La C.I es obligatoria');
        }
        return $this->validationHandler;

    }

    public function canChangePassword(string $password){

        $this->validatePassword($password);
        return $this->validationHandler;

    }
}
?>
