<?php
declare(strict_types=1);
namespace src\domain\user;

interface UserRepository{

    public function getUser(string $field, $value): User;

    public function login(string $email, string $clave): User;

    public function search(array $parameters,array $limits): array;

	public function totalSearch(array $parameters): int;
    
    public function providerAll(): array;

	public function totalproviderAll(): int;

	public function add(User $user): User;

    public function update(User $user): bool;

    public function isValidOldPassword(int $idUpdate, string $password): bool;
    
    public function updatePassword(User $user): bool;

	public function changeStatus(User $user): bool;

    public function delete(User $user): bool;

    public function validUser(User $user): bool;
    
    public function isValueExist(string $field, $value, int $id): bool;

}
?>