<?php
declare(strict_types=1);
namespace src\domain\user;

use Exception;
use src\domain\validation\ValidationHandler;

class User{

    protected $id;
    protected $name;
    protected $password;
    protected $type;
    protected $email;
    protected $status;
    protected $userAdd;
    protected $dateAdd;
    protected $userUpdate;
    protected $dateUpdate;

	public function __construct(
        ?int $id,
        string $name,
        string $email,
        int $type, 
        ?string $password,
        int $status,
        ?int $userAdd,
        ?int $userUpdate,
        ?string $dateAdd, 
        ?string $dateUpdate
    ){

        $this->id = $id;
        $this->name = $name;
        $this->password = $password;
        $this->email = $email;
        $this->type = $type;
        $this->status = $status;
        $this->userAdd = $userAdd;
        $this->dateAdd = $dateAdd;
        $this->userUpdate = $userUpdate; 
        $this->dateUpdate = $dateUpdate;
        $this->userUpdate = $userUpdate;
        
    }

    public static function canChangePassword(string $password) : ValidationHandler{
        
        $userValidator = new UserValidation();
        return $userValidator->canChangePassword($password);
        
    }

    public function changeStatus( int $newStatus , int $idUserUpdate ){

        $this->status = $newStatus;
        $this->userUpdate = $idUserUpdate;
        $this->dateUpdate = date('Y-m-d H:i:s');

    }

    public function changePassword( string $password, int $idUser ){

        $this->password = $password;
        $this->userUpdate = $idUser;
        $this->dateUpdate = date('Y-m-d H:i:s');

    }

    public function RecoveryPassword( string $password){

        $this->password = $password;
        $this->userUpdate = $this->id;
        $this->dateUpdate = date('Y-m-d H:i:s');

    }

    public function getId(){
        return $this->id;
    }

    public function getName(){
        return $this->name;
    }

    public function getEmail(){
        return $this->email;
    }

    public function getDateAdd(){
        return date('d/m/Y',strtotime($this->dateAdd));
    }

    public function getDateUpdate(){
        return date('d/m/Y',strtotime($this->dateUpdate));
    }

    public function getType(){
        return $this->type;
    }

    public function setId($id){
        $this->id = $id;
    }

    public function getUserUpdate(){
        return $this->userUpdate;
    }

    public function getUserAdd(){
        return $this->userAdd;
    }

    public function getPassword(){
        return $this->password;
    }

    public function getStatus(){
        return $this->status;
    }

}
?>
