<?php
declare(strict_types=1);
namespace src\domain\media;

use Exception;
use src\utils\Helper;

class FilePdf extends File{

    private  $path = __DIR__.'/../../../file';

	public function __construct($name,$location, $type){

        $type = strtolower( trim($type) );
        $helper = new Helper();

        if( $this->validType( $type )){

            $name = $helper->friendlyUrl($name).'.pdf';
            Parent::__construct($name,$location,$this->path.'/'.$name);

        }else{

            throw new Exception('Formato de archivo no v&aacute;lido. Formatos permitido pdf');

        }

        
    }

    private function validType(string $type) : bool{

        $typesValid = array("pdf");
        return in_array($type,$typesValid);

    }

}
?>
