<?php
declare(strict_types=1);
namespace src\domain\media;

use Exception;

class FileExcel extends File{

    private  $path = __DIR__.'/../../../admin/excel';

	public function __construct($location, $type){

        $type = strtolower( trim($type) );

        if( $this->validType( $type )){

            $name = date("Y-m-d-H-i-s").'.'.$type;
            Parent::__construct($name,$location,$this->path.'/'.$name);

        }else{

            throw new Exception('Formato de archivo no v&aacute;lido. Formatos permitidos xlsx o xls');

        }

        
    }

    private function validType(string $type) : bool{

        $typesValid = array("xlsx","xls");
        return in_array($type,$typesValid);

    }

}
?>
