<?php
declare(strict_types=1);
namespace src\domain\event;
use JsonSerializable;

class LogEventStored implements JsonSerializable , LogEvent{

    private $user;
    private $section;
    private $action;
    private $browser;
    private $ip;
    private $date;

	public function __construct(
        int $user,
        string $section,
        string $action,
        string $browser,  
        string $ip, 
        string $date
    ){

        $this->user = $user;
        $this->section = $section;
        $this->action = $action;
        $this->browser = $browser;
        $this->ip = $ip;
        $this->date = $date;

    }
    
    public function getUser() : int{
        return $this->user;
    }

    public function getSection() : string {
        return $this->section;
    }

    
    public function getAction() : string {
        return $this->action;
    }

    public function getBrowser() : string {
        return $this->browser;
    }

    public function getIp() : string {
        return $this->ip;
    }

    public function getDate() : string {
        return date('d/m/Y',strtotime($this->date));
    }

    public function jsonSerialize() {
        return [
            'user' => $this->getUser(),
            'section' => $this->getSection(),
            'action' => $this->getAction(),
            'browser' => $this->getBrowser(),
            'ip' => $this->getIp(),
            'date' => $this->getDate()
        ];
    }
}
?>
