<?php
declare(strict_types=1);

namespace src\domain\event;

class LogEventPublisher {

    private $subscribers;
    private static $instance = null;
 
    public static function instance(){

        if (null === static::$instance) {
            static::$instance = new static();
        }
        return static::$instance;
    }

    private function __construct(){
        $this->subscribers = [];
    }

    public function subscribe( LogEventSubscriber $subscriber) {
        $this->subscribers[] = $subscriber;
    }

    public function publish(LogEvent $event) {

        foreach ($this->subscribers as $subscriber) {
            if ($subscriber->isSubscribedTo($event)) {
                $subscriber->handle($event);
            }
        }
    }
}
?>

