<?php
declare(strict_types=1);
namespace src\domain\event;

abstract class LogEventData implements LogEvent {

    protected $user;

	public function __construct(int $user){

        $this->user = $user;
	}
   
    public function getUser() : int{
        return intval($this->user) ;
    }

    abstract public function getSection() : string;

    abstract function getAction() : string;

    public function getBrowser() : string {
        return NAVEGADOR;
    }

    public function getIp() : string {
        return IP;
    }

    public function getDate() : string {
        return date('d/m/Y');
    }

}
?>
