<?php
declare(strict_types=1);
namespace src\domain\document;

use src\domain\validation\Validator;
use src\domain\validation\ValidationHandler;

class DocumentValidation extends Validator{

	public function __construct(){

        $validationHandler = new ValidationHandler();
        parent::__construct($validationHandler);

    }
    
    public function canSave(string $name, string $file, DocumentCategory $category) : ValidationHandler{

        if($name == ''){
            $this->validationHandler->addError('El nombre es obligatorio');
        }
        if($file == ''){
            $this->validationHandler->addError('El archivo es obligatorio');
        }
        if($category->getName() == ''){
            $this->validationHandler->addError('La categor&iacute;a es obligatoria');
        }
        return $this->validationHandler;

    
    }
    
}
?>
