<?php
declare(strict_types=1);
namespace src\domain\document;

use src\domain\event\LogEventData;

class DocumentUpdated extends LogEventData {

    private $documentSaved;

	public function __construct(int $user, string $documentSaved){

        $this->documentSaved = $documentSaved;
        parent::__construct($user);
	}

    public function getSection() : string {
        return 'file';
    }
    
    public function getAction() : string {
        return 'Actuali&oacute; el archivo '.$this->documentSaved;
    }

}
?>
