<?php
declare(strict_types=1);
namespace src\domain\document;

interface DocumentRepository{

    public function getDocument(string $field, $value): Document;

    public function search(array $parameters,array $limits): array;

	public function totalSearch(array $parameters): int;

	public function add(Document $document): Document;

    public function update(Document $document): Document;

	public function changeStatus(Document $document): bool;

    public function delete(Document $document): bool;

    public function isValueExist(string $field, $value, int $id): bool;

}
?>