<?php
declare(strict_types=1);
namespace src\domain\document;

class DocumentDTO{

    public $id;
    public $name;
    public $status;
    public $file;
    public $idCategory;
    public $nameCategory;
    public $provider;
    public $typeUser;
    public $date;
    public $dateAdd;
    public $dateUpdate;

	public function __construct(Document $document){

        $this->id = $document->getId();
        $this->name = $document->getName();
        $this->status = $document->getStatus();
        $this->file = $document->getFile();
        $this->idCategory = $document->getCategory()->getId();
        $this->nameCategory = $document->getCategory()->getName();
        $this->provider = $document->getProvider();
        $this->typeUser = $document->getTypeUser();
        $this->date = $document->getDate();
        $this->dateAdd = $document->getDateAdd();
        $this->dateUpdate = $document->getDateUpdate();
        
    }
}
?>
