<?php
declare(strict_types=1);
namespace src\domain\document;

class DocumentCustom extends Document{

    public function __construct(){}

    public static function fromRawData($data){

        $document = new self();
        $document->id = intval($data['id']);
        $document->name = $data['name'];
        $document->file = $data['file'];
        $document->category = new DocumentCategory(intval($data['idCategory']),$data['nameCategory']);
        
        if($data['provider'] != null){

            $document->provider = explode(',',$data['provider']);
        
        }else{

            $document->provider = array();

        }

        $document->typeUser = $data['type_user'];
        $document->date = $data['date'];
        $document->status = $data['status'];
        $document->userAdd = intval($data['user_add']);
        $document->userUpdate = intval($data['user_update']);
        $document->dateAdd = $data['date_add'];
        $document->dateUpdate = $data['date_update'];

        return $document;

    }
}
?>