<?php
declare(strict_types=1);
namespace src\domain\document;

use src\domain\event\LogEventData;

class CategoryUpdated extends LogEventData {

    private $categorySaved;

	public function __construct(int $user, string $categorySaved){

        $this->categorySaved = $categorySaved;
        parent::__construct($user);
	}

    public function getSection() : string {
        return 'file';
    }
    
    public function getAction() : string {
        return 'Actuali&oacute; la categor&iacute;a '.$this->categorySaved;
    }

}
?>
