<?php
declare(strict_types=1);
namespace src\domain\document;

interface CategoryRepository{

    public function getCategory(string $field, $value): Category;

    public function search(array $parameters,array $limits): array;

	public function totalSearch(array $parameters): int;

	public function add(Category $category): Category;

    public function update(Category $category): bool;

	public function changeStatus(Category $category): bool;

    public function delete(Category $category): bool;

}
?>