<?php
declare(strict_types=1);
namespace src\domain\document;

use src\domain\event\LogEventData;

class CategoryCreated extends LogEventData {

    private $categorySaved;

	public function __construct(int $user, string $categorySaved){

        $this->categorySaved = $categorySaved;
        parent::__construct($user);
	}

    public function getSection() : string {
        return 'file';
    }
    
    public function getAction() : string {
        return 'Cre&oacute; la categor&iacute;a '.$this->categorySaved;
    }

}
?>
