<?php
declare(strict_types=1);
namespace src\domain\document;

use Exception;
use src\domain\event\LogEventPublisher;
use src\domain\validation\ValidationHandler;

class Category{

    protected $id;
    protected $name;
    protected $ico;
    protected $status;
    protected $type;
    protected $userAdd;
    protected $dateAdd;
    protected $userUpdate;
    protected $dateUpdate;

	public function __construct(
        ?int $id,
        string $name,
        string $ico,
        int $status,
        int $type,
        ?int $userAdd,
        ?int $userUpdate,
        ?string $dateAdd, 
        ?string $dateUpdate
    ){

        $errors = $this->canSave($name);
        if(!$errors->hasError()){


            $this->id = $id;
            $this->name = $name;
            $this->ico = $ico;
            $this->type = $type;
            $this->status = $status;
            $this->userAdd = $userAdd;
            $this->dateAdd = $dateAdd;
            $this->userUpdate = $userUpdate; 
            $this->dateUpdate = $dateUpdate;
            LogEventPublisher::instance()->publish(
                new CategoryCreated($this->userAdd,$this->name)
            );

        }else{

            throw new Exception( $errors->printErrors() );

        }
        
    }

    public function update( CategoryDTO $categoryData){

        $errors = $this->canSave($categoryData->name);
        if(!$errors->hasError()){

            $this->name = $categoryData->name;
            $this->ico = $categoryData->ico;
            $this->userUpdate = $categoryData->userUpdate;
            $this->dateUpdate = date('Y-m-d H:i:s');
            LogEventPublisher::instance()->publish(
                new CategoryUpdated($this->userUpdate,$this->name)
            );
               


        }else{

            throw new Exception( $errors->printErrors() );

        }

    }

    public function changeStatus( int $newStatus , int $idUserUpdate ){

        $this->status = $newStatus;
        $this->userUpdate = $idUserUpdate;
        $this->dateUpdate = date('Y-m-d H:i:s');
        LogEventPublisher::instance()->publish(
            new CategoryUpdated($this->userUpdate,$this->name)
        );

    }
    
    public function delete( int $idUserUpdate ){

        LogEventPublisher::instance()->publish(
            new CategoryDeleted($this->userUpdate,$this->name)
        );

    }

    public static function canSave(string $name) : ValidationHandler{
        
        $categoryValidator = new CategoryValidation();
        return $categoryValidator->canSave($name);
        
    }

    public function getId(){
        return $this->id;
    }

    public function getName(){
        return $this->name;
    }

    public function getDateAdd(){
        return date('d/m/Y',strtotime($this->dateAdd));
    }

    public function getDateUpdate(){
        return date('d/m/Y',strtotime($this->dateUpdate));
    }

    public function setId($id){
        $this->id = $id;
    }

    public function getUserUpdate(){
        return $this->userUpdate;
    }

    public function getUserAdd(){
        return $this->userAdd;
    }

    public function getStatus(){
        return $this->status;
    }
    
    public function getIco(){
        return $this->ico;
    }

    public function getType(){
        return $this->type;
    }
}
?>
