<?php
declare(strict_types=1);
namespace src\application\validation;

use src\domain\document\DocumentRepository;

class ValidFilePdf {

    private $documentRepository;

	public function __construct( DocumentRepository $documentRepository ){

        $this->documentRepository = $documentRepository;
    }
    
    /**
     * Verifica si hay un provider con el c.i suministrado
     *
     * @param ValidationRequest $request
     * @return array
     */

    public function execute( ValidationRequest $request ) : array {

        try{


            if($this->documentRepository->isValueExist( 'file',$request->getData(),$request->getId() )){

                return array("success"=>true,"message"=>'El nombre del archivo ya se encuentra registrado');

            }else{

                return array("success"=>false,"message"=>'El nombre del archivo no se encuentra registrado');
            }
            
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
