<?php
declare(strict_types=1);
namespace src\application\validation;

use src\domain\user\UserRepository;

class ValidEmailUser {

    private $userRepository;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
    }
    
    /**
     * Verifica si hay un usuario con el email suministrado
     *
     * @param ValidationRequest $request
     * @return array
     */

    public function execute( ValidationRequest $request ) : array {

        try{


            if($this->userRepository->isValueExist( 'email',$request->getData(),$request->getId() )){

                return array("success"=>true,"message"=>'El email se encuentra registrado');

            }else{

                return array("success"=>false,"message"=>'El email no se encuentra registrado');
            }
            
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
