<?php
declare(strict_types=1);
namespace src\application\validation;

use src\domain\user\UserRepository;

class ValidCiUser {

    private $userRepository;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
    }
    
    /**
     * Verifica si hay un provider con el c.i suministrado
     *
     * @param ValidationRequest $request
     * @return array
     */

    public function execute( ValidationRequest $request ) : array {

        try{


            if($this->userRepository->isValueExist( 'ci',$request->getData(),$request->getId() )){

                return array("success"=>true,"message"=>'La C.I se encuentra registrada');

            }else{

                return array("success"=>false,"message"=>'La C.I no se encuentra registrada');
            }
            
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
