<?php
declare(strict_types=1);
namespace src\application\user;

class UserRequest {

    private $id;
    private $name;
    private $email;
    private $status;
    private $password;
    private $type;

	public function __construct( 
        ?int $id,
        string $name, 
        string $email,
        int $status,
        ?string $password,
        int $type
    ){
            
        $this->id = $id;
        $this->name = $name;
        $this->email = $email;
        $this->password = $password;
        $this->status = $status;
        $this->type = $type;
    }

    public function getId(){
        return $this->id;
    }

    public function getEmail() : string {
        return $this->email;
    }

    public function getPassword() : ?string {
        return $this->password;
    }

    public function getName(){
        return $this->name;
    }

    public function getStatus(){
        return $this->status;
    }

    public function getType(){
        return $this->type;
    }
}
?>
