<?php
declare(strict_types=1);
namespace src\application\user;

use src\domain\user\UserDTO;
use src\application\Authorization;
use src\domain\user\UserRepository;
use src\application\exception\SessionExpire;

class UserList {

    private $userRepository;
    private $authorization;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();    
    }

    private function transformToUserDTO( array $users ) : array{

        $usersDto = array();

        if( count($users) ){

            foreach($users as $user){

                $usersDto[] = new UserDTO($user);

            }

        }

        return $usersDto;

    }

    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }else{

            if(!$this->authorization->isAdmin()){

                throw new UserInvalid();

            }


        }

    }
    
    /**
     * @param UserListRequest $request
     * @return array De dos posiciones con los registros correspondientes a la busqueda paginados y el total de registros
    */
    public function execute( UserListRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "registers" => $this->transformToUserDTO(
                    $this->userRepository->search($request->getSearch(),$request->getLimit())
                ),
                "total" => $this->userRepository->totalSearch($request->getSearch())
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
