<?php
declare(strict_types=1);
namespace src\application\user;

use src\domain\user\UserDTO;
use src\application\Authorization;
use src\domain\user\UserRepository;
use src\application\exception\SessionExpire;

class UserGet {

    private $userRepository;
    private $authorization;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();    
    }
    
    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }

    }

    public function execute( UserGetRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "user" => new UserDTO( $this->userRepository->getUser('id',$request->getId()) ),
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
