<?php
declare(strict_types=1);
namespace src\application\user;

use src\domain\user\User;
use src\domain\user\UserDTO;
use src\application\Authorization;
use src\application\Authentication;
use src\domain\user\UserRepository;
use src\domain\event\LogEventPublisher;
use src\application\exception\UserInvalid;
use src\application\exception\SessionExpire;
use src\domain\event\LogEventSaveSubscriber;
use src\domain\validation\ValidationHandler;
use src\infrastructure\sql\SqlLogEventStore;

class UserChangeStatus {

    private $userRepository;
    private $authorization;
    private $userLogin;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));    
    }
    
    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }else{

            if(!$this->authorization->isWebmaster()){

                throw new UserInvalid();
            }

        }

    }
    
    public function execute( UserRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $user = $this->userRepository->getUser('id',$request->getId());

            $user->changeStatus( $request->getStatus(), $this->userLogin->id );

            $this->userRepository->changeStatus($user);

            return array("success"=>true,"message"=>"Usuario modificado exitosamente",'user'=>new UserDTO($user));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
