<?php
declare(strict_types=1);
namespace src\application\user;

use src\infrastructure\sql\SqlLogEventStore;
use src\domain\event\LogEventPublisher;
use src\domain\event\LogEventSaveSubscriber;
use src\domain\user\UserRepository;
use src\domain\validation\ValidationHandler;
use src\domain\user\User;
use src\application\Authorization;
use src\application\Authentication;
use src\application\exception\SessionException;
use Exception;

class UserChangePassword {

    private $userRepository;
    private $authorization;
    private $userLogin;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));    
    }
    
    private function checkAuthorization($idUpdate){ 

        if( !$this->authorization->isLogin() ){
    
            throw new SessionException('Sesi&oacute;n expirada');
        
        } 

        if($this->userLogin->id != $idUpdate){ 

            
            if(!$this->authorization->isWebmaster()){
                
                throw new AuthException('Usuario no v&aacutelido para realizar esta operaci&oacute;n');

            }

        }


    }
    
    /**
     * Modifica la clave del usuario
     *
     * @param UserRequest $request
     * @return array
     */
    public function execute( UserRequest $request ) : array{

        $this->checkAuthorization($request->getId());

        try{
            
            $user = $this->userRepository->getUser('id',$request->getId());
            
            $errors = $user->canChangePassword( $request->getPassword() );
            if( $errors->hasError() ){

                throw new \Exception($errors->printErrors());
                
            }

            $user->changePassword( $request->getPassword(), $this->userLogin->id );

            $this->userRepository->updatePassword($user);

            return array("success"=>true,"message"=>"Clave modificada exitosamente",'user'=>$user);
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}

    }
}
?>
