<?php
declare(strict_types=1);
namespace src\application\provider;

use src\domain\user\provider\Provider;
use src\domain\user\provider\ProviderDTO;

class ProviderUpdate extends ProviderService{

    private function transformRequestToDTO (Provider $provider, ProviderRequest $request ) : ProviderDTO{

        $providerDTO = new ProviderDTO($provider);
        
        $providerDTO->name = $request->getNameProvider();
        $providerDTO->ci = $request->getCiProvider();
        $providerDTO->email = $request->getEmailProvider();
        $providerDTO->userUpdate = $this->userLogin->id;

        return $providerDTO;

    }
    
    public function execute( ProviderRequest $request ) : array{
        
        $this->checkAuthorization();
        
        try{
            
            $provider = $this->userRepository->getUser('id',$request->getIdProvider());
            
            if($this->userRepository->isValueExist( 'ci',$request->getCiProvider(),$request->getIdProvider())){

                throw new \Exception('El RIF ya se encuentra registrado');

            }else{

                if($this->userRepository->isValueExist( 'email',$request->getEmailProvider(),$request->getIdProvider() )){

                    throw new \Exception('El email ya se encuentra registrado');
    
                }

            }
            
            $providerDTO = $this->transformRequestToDTO($provider,$request);
            $providerDTO->id = $provider->getId();

            $provider->update($providerDTO,$provider);

            $this->userRepository->update($provider);
        
            return array("success"=>true,"message"=>"Proveedor guardado exitosamente");
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
