<?php
declare(strict_types=1);
namespace src\application\provider;

use src\application\Authorization;
use src\application\Authentication;
use src\domain\user\UserRepository;
use src\domain\event\LogEventPublisher;
use src\domain\student\StudentRepository;
use src\application\exception\UserInvalid;
use src\application\exception\SessionExpire;
use src\domain\event\LogEventSaveSubscriber;
use src\domain\validation\ValidationHandler;
use src\infrastructure\sql\SqlLogEventStore;

class ProviderService {

    protected $userRepository;
    protected $authorization;
    protected $userLogin;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));   

    }
    
    
    protected function checkAuthorization(){
        
        if( !$this->authorization->isLogin() ){
            
            throw new SessionExpire();
            
        }
        
    }
}
?>
