<?php
declare(strict_types=1);
namespace src\application\provider;

use src\EmailInterface;
use src\application\Authorization;
use src\domain\user\UserRepository;
use src\application\TokenValidEmail;
use src\application\user\UserGetRequest;
use src\application\exception\SessionExpire;
use src\domain\user\provider\ProviderDTO;

class ProviderSendValid {

    private $userRepository;
    private $email;
    private $authorization;

	public function __construct( UserRepository $userRepository ,EmailInterface $email){

        $this->userRepository = $userRepository;
        $this->email = $email;
        $this->authorization = new Authorization();    
    }

    public function execute( UserGetRequest $request ) : array{

        try{
            
            $provider = $this->userRepository->getUser($request->getField(),$request->getId());
            $tokenValid = new TokenValidEmail();
            $token = $tokenValid->setData($provider);

            $send = $this->email->sendValid( ucwords($provider->getName()),$provider->getEmail(),$token);

            if($send){

                return array("success"=>true,"message"=>"Se acaba de enviar un mensaje al email suministrado con los pasos para la validaci&oacute;n. Por favor revisar en su carpeta de correos no deseados.");

            }else{

                throw new Exception('Ha ocurrido un error al enviar el correo. Por favor int&eacute;ntelo mas tarde');

            }

        }catch(\Exception $e){

			throw new \Exception($e->getMessage().'. Por favor comun&iacute;case con la empresa para actualizar sus datos');

		}



    }
}
?>
