<?php
declare(strict_types=1);
namespace src\application\provider;

class ProviderRequest {

    private $nameProvider;
    private $emailProvider;
    private $ciProvider;
    private $idProvider;
    private $status;
    private $type;

	public function __construct(
        string $nameProvider,
        string $emailProvider,
        string $ciProvider,
        ?int $idProvider,
        int $type,
        int $status
    ){
        $this->nameProvider = strtolower(trim($nameProvider));
        $this->emailProvider = strtolower(trim($emailProvider));
        $this->ciProvider = strtolower(trim($ciProvider));
        $this->idProvider = $idProvider;
        $this->status = $status;
        $this->type = $type;
    }

    public function getNameProvider(){
        return $this->nameProvider;
    }

    public function getEmailProvider(){
        return $this->emailProvider;
    }

    public function getCiProvider(){
        return $this->ciProvider;
    }

    public function getIdProvider(){
        return $this->idProvider;
    }

    public function getStatus(){
        return $this->status;
    }

    public function getType(){
        return $this->type;
    }
}
?>
