<?php
declare(strict_types=1);
namespace src\application\provider;

use src\domain\user\UserDTO;
use src\application\Authorization;
use src\domain\user\UserRepository;
use src\application\exception\SessionExpire;

class ProviderList {

    private $userRepository;
    private $authorization;

	public function __construct( UserRepository $userRepository ){

        $this->userRepository = $userRepository;
        $this->authorization = new Authorization();    
    }

    private function transformToUserDTO( array $users ) : array{

        $usersDto = array();

        if( count($users) ){

            foreach($users as $user){

                $usersDto[] = new UserDTO($user);

            }

        }

        return $usersDto;

    }

    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }else{

            if(!$this->authorization->isAdmin()){

                throw new UserInvalid();

            }


        }

    }
    
    public function execute( ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "registers" => $this->transformToUserDTO(
                    $this->userRepository->providerAll()
                ),
                "total" => $this->userRepository->totalproviderAll()
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
