<?php
declare(strict_types=1);
namespace src\application\provider;

use src\domain\user\provider\ProviderDTO;

class ProviderGet extends ProviderService{

    public function execute( ProviderGetRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $provider = $this->userRepository->getUser($request->getField(),$request->getId());
            
            return [
                "provider" => new ProviderDTO( $provider ),
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
