<?php
declare(strict_types=1);
namespace src\application\provider;

class ProviderDelete extends ProviderService{
    
    public function execute( ProviderGetRequest $request ) : array{
        
        $this->checkAuthorization();
        
        try{
            
            $provider = $this->userRepository->getUser($request->getField(),$request->getId());
            $this->userRepository->delete($provider);
        
            return array("success"=>true,"message"=>"Proveedor eliminado exitosamente");
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
