<?php
declare(strict_types=1);
namespace src\application\provider;

use src\domain\user\provider\Provider;
use src\domain\user\provider\ProviderDTO;

class ProviderCreate extends ProviderService{

    public function execute( ProviderRequest $request ) : array{
        
        $this->checkAuthorization();
        
        try{
            
            if($this->userRepository->isValueExist( 'ci',$request->getCiProvider(),-1 )){

                $provider = $this->userRepository->getUser('ci',$request->getCiProvider());

            }else{

                if($this->userRepository->isValueExist( 'email',$request->getEmailProvider(),-1 )){

                    throw new \Exception('El email ya se encuentra registrado');
    
                }

                $errors = Provider::canSave( $request->getNameProvider(),$request->getCiProvider(),$request->getEmailProvider() );

                if( $errors->hasError() ){

                    throw new \Exception($errors->printErrors());
                    
                }

                $provider = new Provider( 
                    NULL, 
                    $request->getNameProvider(), 
                    $request->getEmailProvider(),
                    $request->getCiProvider(),
                    $request->getType(),
                    1,
                    $this->userLogin->id,
                    $this->userLogin->id,
                    date('Y-m-d H:i:s'),
                    date('Y-m-d H:i:s')
                );

                $this->userRepository->add($provider);

            }
        
            return array("success"=>true,"message"=>"Proveedor creado exitosamente",'student'=>new ProviderDTO($provider));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
