<?php
declare(strict_types=1);
namespace src\application\provider;

use src\EmailInterface;
use src\domain\user\UserRepository;
use src\application\user\UserGetRequest;
use src\domain\user\provider\ProviderDTO;

class ProviderActive {

    private $userRepository;
    private $email;
	public function __construct( UserRepository $userRepository ,EmailInterface $email){

        $this->userRepository = $userRepository;
        $this->email = $email;
    }

    private function getNewPassword() : string {

        $key = '';
 		$pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
 		$max = strlen($pattern)-1;
 		for($i=0;$i < 10;$i++){
			 $key .= $pattern{mt_rand(0,$max)};
		}
 		return $key;

    }

    public function execute( UserGetRequest $request ) : array{

        try{
            
            $provider = $this->userRepository->getUser($request->getField(),$request->getId());
            $password = $this->getNewPassword();
            $provider->active( $password);
            $this->userRepository->updatePassword($provider,$provider->getId());
            $this->userRepository->validUser($provider);

            $send = $this->email->activeAccount( ucwords($provider->getName()),$provider->getEmail(), $password);

            if($send){

                return array("success"=>true,"message"=>"La validaci&oacute;n de su email sido realizada exitosamente. Sus datos de acceso han sido enviados al email suministrado. Por favor revisar en su carpeta de correos no deseados.");

            }else{

                throw new Exception('Ha ocurrido un error al enviar el correo. Por favor int&eacute;ntelo mas tarde');

            }

        }catch(\Exception $e){

			throw new \Exception($e->getMessage().'. Por favor comun&iacute;case con la empresa para actualizar sus datos');

		}



    }
}
?>
