<?php
declare(strict_types=1);
namespace src\application\provider;

use Exception;

require_once $GLOBALS['app_root'].'/src/utils/phpexcel/vendor/autoload.php';

use src\domain\user\provider\Provider;
use PhpOffice\PhpSpreadsheet\IOFactory;

class ProcessDataExcelProvider extends ProviderService{
    
    /**
     * Lee los datos del excel suministrado de proveedores y retorna un array con el resultado de la operacion de creacion por fila
     *
     * @return array
     */
    public function execute(string $file, int $type) : array{

        $this->checkAuthorization();

        try{

            $dataResult = array();
            $spreadsheet = IOFactory::load($file);
            $sheetData = $spreadsheet->getActiveSheet()->toArray();
            $index = 0;

            if(count($sheetData)>0){
        
                foreach($sheetData as $data){ 
        
                    $name = ($data[0] != '') ? strtolower(trim($data[0])) : $data[0];
                    $ci = ($data[1] != '') ? strtolower(trim($data[1].'')) : $data[1];
                    $email = ($data[2] != '') ? strtolower(trim($data[2])) : $data[2];
                    
                    $dataResult[$index]['name'] = addslashes(utf8_decode($name));
                    $dataResult[$index]['ci'] = $ci;
                    $dataResult[$index]['email'] = $email;

                    if(($name != "") && ($ci != "") && ($email != "")){

                        try{

                            if($this->userRepository->isValueExist( 'ci',$ci,-1 )){
    
                                $provider = $this->userRepository->getUser('ci',$ci);
    
                            }else{

                                if($this->userRepository->isValueExist( 'email',$email,-1 )){

                                    throw new \Exception('El email ya se encuentra registrado');
                    
                                }
    
                                $provider = new Provider( 
                                    NULL, 
                                    $name, 
                                    $email,
                                    $ci,
                                    $type,
                                    1,
                                    $this->userLogin->id,
                                    $this->userLogin->id,
                                    date('Y-m-d H:i:s'),
                                    date('Y-m-d H:i:s')
                                );
    
                                $this->userRepository->add($provider);
    
                            }

                            $dataResult[$index]["success"] = true;
                            $dataResult[$index]["result"] = 'Registro agregado exitosamente';

                        }catch(Exception $e){

                            $dataResult[$index]["success"] = false;
                            $dataResult[$index]["result"] = $e->getMessage();

                        }
        
                    }else{
                        $dataResult[$index]["success"] = false;
                        $dataResult[$index]["result"] = 'Hay datos en blanco';
                    }
        
                    $index++;
                }

                return $dataResult;
        
            }else{

                throw new Exception('El excel se encuentra vacio');
            
            }

        }catch(Exception $e){

			throw new Exception($e->getMessage());

		}



    }
}
?>
