<?php
declare(strict_types=1);
namespace src\application\media;

use Exception;
use src\domain\media\FilePdf;
use src\domain\media\MediaUpload;

class UploadPdfService {

    private $mediaUpload;

	public function __construct( MediaUpload $mediaUpload ){

        $this->mediaUpload = $mediaUpload;    
    }
    
    public function execute( UploadFileRequest $request ) : array{

        try{

            $file = $request->getFile();
            $nameFile = $file['name'];
            $temporal = $file['tmp_name'];
            $extension = explode(".",$nameFile);
            $long = count($extension) - 1;

            $filePdf = new FilePdf($extension[0],$temporal,$extension[$long]);
            if( $this->mediaUpload->upload( $filePdf->getLocation(), $filePdf->getNewLocation() ) ){

                return [ "nameFile" => $filePdf->getName() ];

            }else{

                throw new Exception('Error al subir el archivo. Por favor int&eacute;ntelo mas tarde');

            }
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
