<?php
declare(strict_types=1);
namespace src\application\media;

use Exception;
use src\domain\media\FileExcel;
use src\domain\media\MediaUpload;

class UploadFileExcelService {

    private $mediaUpload;

	public function __construct( MediaUpload $mediaUpload ){

        $this->mediaUpload = $mediaUpload;    
    }
    
    public function execute( UploadFileRequest $request ) : array{

        try{

            $file = $request->getFile();
            $nameFile = $file['name'];
            $temporal = $file['tmp_name'];
            $extension = explode(".",$nameFile);
            $long = count($extension) - 1;

            $fileExcel = new FileExcel($temporal,$extension[$long]);
            if( $this->mediaUpload->upload( $fileExcel->getLocation(), $fileExcel->getNewLocation() ) ){

                return [ "nameFile" => $fileExcel->getNewLocation() ];

            }else{

                throw new Exception('Error al subir el archivo. Por favor int&eacute;ntelo mas tarde');

            }
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
